{**
 * 2007-2018 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 * @author    PrestaShop SA <contact@prestashop.com>
 * @copyright 2007-2018 PrestaShop SA
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 * International Registered Trademark & Property of PrestaShop SA
 *}
<div id="_desktop_cart" class="dropdown js-dropdown">
  <div class="blockcart cart-preview {if $cart.products_count > 0}active{else}inactive{/if}" data-refresh-url="{$refresh_url}" >
    <div class="header" data-toggle="dropdown">
      <div class="shopping_cart_main">
        <i class="material-icons shopping-cart"></i>
        <span class="cart-products-count">{$cart.products_count}</span>
      </div> 


    </div>
  {if $cart.products_count > 0}
            <div class="cart-drop-contents dropdown-menu">
                <ul>
                    {foreach from=$cart.products item=product}
                        <li class="cart-wishlist-item">
                            {include 'module:ps_shoppingcart/ps_shoppingcart-product-line.tpl' product=$product}
                        </li>
                    {/foreach}
                </ul>
                <div class="cart-summary">
                    <div class="cart-subtotals">
                        {foreach from=$cart.subtotals item="subtotal"}
                            <div class="{$subtotal.type} box-content">
                                <span class="label">{$subtotal.label}</span>
                                <span class="value">{$subtotal.value}</span>
                            </div>
                        {/foreach}
                    </div>
                    <div class="cart-total box-content">
                        <span class="label">{$cart.totals.total.label}</span>
                        <span class="value">{$cart.totals.total.value}</span>
                    </div>
                </div>
                <div class="cart-wishlist-action">
                    <a class="btn btn-primary" href="{$cart_url}">{l s='Checkout' d='Shop.Theme.Actions'}</a>
                </div>
            </div> 
        {else}
           <div class="cart-drop-contents dropdown-menu">
                <span class="no-item">{l s='There are no more items in your cart' d='Shop.Theme.Checkout'}</span>
            </div>
  {/if}
    </div>
</div>
